% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotScore.R
\name{plotScore}
\alias{plotScore}
\title{Plot score for prcomp result}
\usage{
plotScore(prcompResult, xPC = 1, yPC = 2, group = NULL, group2 = NULL,
  cex = 1.5, cex.legend = 1, label = NULL, pos = 4, col = NULL,
  pch = NULL, legendlocation = "bottomright", legendoutside = FALSE,
  rightwhitespace = 0, ...)
}
\arguments{
\item{prcompResult}{output object from \code{\link[stats]{prcomp}} function}

\item{xPC}{an integer indicating PC component on x-axis}

\item{yPC}{an integer indicating PC component on y-axis}

\item{group}{a vector of numeric, character or factor class separating 
the samples into groups. Correspond to point color.}

\item{group2}{The second group, can be a vector of numeric, character or factor class separating 
the samples into groups. Correspond to point shape.}

\item{cex}{(optional) size of points on graphs}

\item{cex.legend}{(optional) size of fonts in legend}

\item{label}{(optional) a character vector or expression specifying the text to be written.}

\item{pos}{(optional, applicable when label is given) a position specifier for the text. If specified this overrides 
any adj value given. Values of 1, 2, 3 and 4, respectively indicate positions below, 
to the left of, above and to the right of the specified coordinates.}

\item{col}{point color palette}

\item{pch}{point type palette}

\item{legendlocation}{(optional)location of legend on graph. 
Look up \code{\link[graphics]{legend}} for more details.}

\item{legendoutside}{(optional) set to TRUE if you want to put legend on 
the outside of the plot. The legend location is defaulted to topright.}

\item{rightwhitespace}{(optional) set width for white space for legend. 
Only applicable if legendoutside = TRUE}

\item{...}{additional arguments for \code{\link[graphics]{par}}}
}
\value{
A figure is returned on the graphic device
}
\description{
Plot score for \code{\link[stats]{prcomp}} (PCA) result
}
\examples{
data(applejuice)
applejuice_uf <- unfold(applejuice) # unfold list into matrix
result <- prcomp(applejuice_uf) 
plotScore(result) # plot PC1 vs PC2 score
plotScore(result, pch = 3, col = "blue") # change shape and color

# get country of apple production
country <- sapply(strsplit(names(applejuice), split = "-"), "[", 1) 
plotScore(result, label = country) # add label

# or plot by group
plotScore(result, xPC = 1, yPC = 3, group = country) 

# custom point types and color
plotScore(result, xPC = 1, yPC = 3, group = country, pch = c(1,2), col = c("green", "black"))

# move legend outside
plotScore(result, xPC = 1, yPC = 3, group = country, legendoutside = TRUE)

# two groups
cultivar <- sapply(strsplit(names(applejuice), split = "-"), "[", 2) 
plotScore(result, group = country, group2 = cultivar)

# make the points more transparent
\dontrun{
require(scales)
plotScore(result, group = country, group2 = country, col = alpha(generateColor(2), 0.7))
}

}
\seealso{
\code{\link{plotScorem}}
}

