% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN_seq_network_structures.R
\name{Recurrent_GPD_net}
\alias{Recurrent_GPD_net}
\title{Recurrent network module for GPD parameter prediction}
\usage{
Recurrent_GPD_net(
  type = c("lstm", "gru"),
  nb_input_features,
  hidden_size,
  num_layers = 1,
  dropout = 0,
  shape_fixed = FALSE,
  device = EQRN::default_device()
)
}
\arguments{
\item{type}{the type of recurrent architecture, can be one of \code{"lstm"} (default) or \code{"gru"},}

\item{nb_input_features}{the input size (i.e. the number of features),}

\item{hidden_size}{the dimension of the hidden latent state variables in the recurrent network,}

\item{num_layers}{the number of recurrent layers,}

\item{dropout}{probability parameter for dropout before each hidden layer for regularization during training,}

\item{shape_fixed}{whether the shape estimate depends on the covariates or not (bool),}

\item{device}{a \code{\link[torch:torch_device]{torch::torch_device()}} for an internal constant vector. Defaults to \code{\link[=default_device]{default_device()}}.}
}
\value{
The specified recurrent GPD network as a \code{\link[torch:nn_module]{torch::nn_module}}.
}
\description{
A recurrent neural network as a \code{\link[torch:nn_module]{torch::nn_module}},
designed for generalized Pareto distribution parameter prediction, with sequential dependence.
}
\details{
The constructor allows specifying:
\describe{
\item{type}{the type of recurrent architecture, can be one of \code{"lstm"} (default) or \code{"gru"},}
\item{nb_input_features}{the input size (i.e. the number of features),}
\item{hidden_size}{the dimension of the hidden latent state variables in the recurrent network,}
\item{num_layers}{the number of recurrent layers,}
\item{dropout}{probability parameter for dropout before each hidden layer for regularization during training,}
\item{shape_fixed}{whether the shape estimate depends on the covariates or not (bool),}
\item{device}{a \code{\link[torch:torch_device]{torch::torch_device()}} for an internal constant vector. Defaults to \code{\link[=default_device]{default_device()}}.}
}
}
