% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitbsgpd.R
\name{fitbsgpd}
\alias{fitbsgpd}
\title{Fitting the Birnbaum-Saunders-Generalized Pareto distribution}
\usage{
fitbsgpd(starts, data)
}
\arguments{
\item{starts}{A vector defining the starting values for the Nelder-Mead algorithm.}

\item{data}{A vector containing the observations}
}
\value{
List the estimated parameters of the distribution with standard errors and goodness-of-fit statistics.
}
\description{
Fitting the Birnbaum-Saunders-Generalized Pareto distribution
}
\examples{
library(VGAM)
data=ERPeq::rbsgpd(500,5,0.7,0.2)
fitbsgpd(starts =c(1,1),data=data)
}
