% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paretocp.R
\name{paretocp}
\alias{paretocp}
\title{Probabilistic estimation of earthquake recurrence interval using Pareto distribution}
\usage{
paretocp(fit, r, te)
}
\arguments{
\item{fit}{Fit is the fitpareto object. See ?fitpareto for details.}

\item{r}{The specified time in which the probability of an earthquake is desired to be calculated.}

\item{te}{Elapsed time since the last earthquake}
}
\value{
A numeric value
}
\description{
Computes the probability of an earthquake within a specified time "r" and elapsed time "te".
}
\examples{
library(VGAM)
data=VGAM::rpareto(200,2,5)
fit=fitpareto(c(0.5),data=data)
paretocp(fit,r=2,te=5)
}
\references{
Pasari, S. and Dikshit, O. (2014). Impact of three-parameter Weibull models in probabilistic assessment of earthquake hazards. Pure and Applied Geophysics, 171, 1251-1281.
}
