% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed_ts.R
\name{embed_ts}
\alias{embed_ts}
\title{Construct an Embedded Timeseries}
\usage{
embed_ts(X, E, tau = 1, sample_times = NULL)
}
\arguments{
\item{X}{A numeric matrix of species abundances, names across columns, time across rows. The first column is a time vector, the remainder are species values.}

\item{E}{Numeric. Embedding dimension.}

\item{tau}{Numeric. Time lag.}

\item{sample_times}{Numeric vector. Defines the time indices to subset prior to embedding.}
}
\value{
A matrix where the first column is last time index of the window and the second column is the estimated index value.
}
\description{
Embeds timeseries given an embedding dimension (`E`) and a time lag (`tau`).
}
\examples{
#Load the multivariate simulated
#dataset `simTransComms`

data(simTransComms)

#Embed one timeseries by 5 time points

eg_embed <- embed_ts(X = simTransComms$community2[,2:3],
E = 5, tau = 1)

}
