% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dropout.R
\name{VisualizeDropout}
\alias{VisualizeDropout}
\title{Make plots to visually assess dropout trends}
\usage{
VisualizeDropout(
  obj,
  plot_type = c("grandR", "bakR"),
  grouping_factors = NULL,
  features = NULL,
  populations = NULL,
  fraction_design = NULL,
  repeatID = NULL,
  exactMatch = TRUE,
  n_min = 50,
  dropout_cutoff = 5,
  ...
)
}
\arguments{
\item{obj}{An EZbakRFractions object, which is an EZbakRData object on which
you have run \code{EstimateFractions()}.}

\item{plot_type}{Which type of plot to make. Options are:
\itemize{
\item bakR: X-axis is fraction new (a.k.a. NTR) and Y-axis is dropout (no label n / label n)
\item grandR: X-axis is fraction new rank (a.k.a. NTR rank) and Y-axis is log(dropout)
}}

\item{grouping_factors}{Which sample-detail columns in the metadf should be used
to group -s4U samples by for calculating the average -s4U RPM? The default value of
\code{NULL} will cause all sample-detail columns to be used.}

\item{features}{Character vector of the set of features you want to stratify
reads by and estimate proportions of each RNA population. The default of \code{NULL}
will expect there to be only one fractions table in the EZbakRFractions object.}

\item{populations}{Mutational populations that were analyzed to generate the
fractions table to use. For example, this would be "TC" for a standard
s4U-based nucleotide recoding experiment.}

\item{fraction_design}{"Design matrix" specifying which RNA populations exist
in your samples. By default, this will be created automatically and will assume
that all combinations of the \code{mutrate_populations} you have requested to analyze are
present in your data. If this is not the case for your data, then you will have
to create one manually. See docs for \code{EstimateFractions} (run ?EstimateFractions()) for more details.}

\item{repeatID}{If multiple \code{fractions} tables exist with the same metadata,
then this is the numerical index by which they are distinguished.}

\item{exactMatch}{If TRUE, then \code{features} must exactly match the \code{features}
metadata for a given fractions table for it to be used. Means that you cannot
specify a subset of features by default. Set this to FALSE if you would like
to specify a feature subset.}

\item{n_min}{Minimum raw number of reads to make it to plot}

\item{dropout_cutoff}{Maximum dropout value included in plot.}

\item{...}{Parameters passed to internal \code{calculate_dropout()} function;}
}
\value{
A list of \code{ggplot2} objects, one for each +label sample.
}
\description{
Plots a measure of dropout (the ratio of -label to +label RPM) as a function
of feature fraction new, with the model fit depicted. Use this function to
qualitatively assess model fit and whether the modeling assumptions are met.
}
\examples{

# Simulate data to analyze
simdata <- EZSimulate(30)

# Create EZbakR input
ezbdo <- EZbakRData(simdata$cB, simdata$metadf)

# Estimate Fractions
ezbdo <- EstimateFractions(ezbdo)

# Visualize Dropout
ezbdo <- VisualizeDropout(ezbdo)

}
