% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.Transpose.R
\name{plot.Transpose}
\alias{plot.Transpose}
\title{This function returns the two principal plots of the Transpose function : a plot by group and the associated Trophic Spectra (CTS, BTS...).}
\usage{
\method{plot}{Transpose}(x, title = NULL, scale = NULL, legend.cex = NULL, ...)
}
\arguments{
\item{x}{is the table returned by the Transpose function.}

\item{title}{defines the title of the graph.}

\item{scale}{defines the scale of the y-axis: can be log or not.}

\item{legend.cex}{defines the value of the cex for the legend.}

\item{\dots}{plot other arguments}
}
\description{
This function returns the two principal plots of the Transpose function : a plot by group and the associated Trophic Spectra (CTS, BTS...).
}
\examples{
data(ecopath_guinee)
smoothed<-create.smooth(ecopath_guinee)
plot(Transpose(smoothed,ecopath_guinee,"biomass"),scale=log)
plot(Transpose(smoothed,ecopath_guinee,"catch.1"),title="Small Scale Fishery Catch")
}
\seealso{
create.smooth function to create the Smooth, plot.smooth to plot the smooth function, Transpose to calculate the data transposition into trophic spectra.
}
