% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_score.r
\name{z_score}
\alias{z_score}
\title{Compute the z-score between technologies from an incidence matrix}
\usage{
z_score(mat)
}
\arguments{
\item{mat}{A patent-technology incidence matrix with patents in rows and technologies in columns}
}
\value{
A matrix of z-scores representing the co-occurrence of technologies in the input incidence matrix. The z-score measures the deviation of the observed co-occurrence from the expected co-occurrence under the assumption of random combination. Positive z-scores indicate typical co-occurrences, while negative z-scores indicate atypical co-occurrences.
}
\description{
This function computes the z-score between pairs of technologies from a patent-technology incidence matrix. The z-score is a measure to analyze the co-occurrence of technologies in patent documents (i.e. knowledge combination). It compares the observed number of co-occurrences to what would be expected under the hypothesis that combination is random. A positive z-score indicates a typical co-occurrence which has occurred multiple times before. In contrast, a negative z-socre indicates an atypical co-occurrence. The z-score has been used to estimate the degree of novelty of patents (Kim 2016), scientific publications (Uzzi et al. 2013) or the relatedness between industries (Teece et al. 1994).
}
\examples{

## Generate a toy incidence matrix
set.seed(2210)
techs <- paste0("T", seq(1, 5))
techs <- sample(techs, 50, replace = TRUE)
patents <- paste0("P", seq(1, 20))
patents <- sort(sample(patents, 50, replace = TRUE))
my_data <- data.frame(patents, techs)
my_dat <- unique(my_data)
mat <- as.matrix(table(my_data$patents, my_data$techs))

## run the function
z_score(mat)

}
\references{
Kim, D., Cerigo, D. B., Jeong, H., and Youn, H. (2016). Technological novelty proile and invention's future impact. \emph{EPJ Data Science}, \bold{5} (1):1--15 \cr
\cr
Teece, D. J., Rumelt, R., Dosi, G., and Winter, S. (1994). Understanding corporate coherence. Theory and evidence. \emph{Journal of Economic Behavior and Organization}, \bold{23} (1):1--30 \cr
\cr
Uzzi, B., Mukherjee, S., Stringer, M., and Jones, B. (2013). Atypical Combinations and Scientific Impact. \emph{Science}, \bold{342} (6157):468--472
}
\seealso{
\code{\link{relatedness_density}}, \code{\link{co_occurrence}}
}
\author{
Lars Mewes \email{mewes@wigeo.uni-hannover.de}
}
\keyword{relatedness}
