% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Elja.R
\name{ELJAlinear}
\alias{ELJAlinear}
\title{Linear regression for EnvWAS/EWAS analysis}
\usage{
ELJAlinear(
  var,
  var_adjust = NULL,
  data,
  manplot = TRUE,
  nbvalmanplot = 100,
  Bonferroni = FALSE,
  FDR = FALSE,
  manplotsign = FALSE
)
}
\arguments{
\item{var}{A categorical and binary variable. It is generally your outcome.}

\item{var_adjust}{A vector containing the names of the fixed adjustment variables for all the models.}

\item{data}{A dataframe containing all the variables needed for the analysis.}

\item{manplot}{Generate a Manhattan plot of the results of the analysis.}

\item{nbvalmanplot}{The number of variables to include in each Manhattan plot.}

\item{Bonferroni}{Add a dashed bar to the Manhattan plot showing the Bonferroni significance level.}

\item{FDR}{Add a dashed bar to the Manhattan plot showing the False Discovery Rate (Benjamini-Hochberg method) significance threshold. NA if all p-values > FDR corrected p-values.}

\item{manplotsign}{Generates a Manhattan plot with only significant results (p<0.05).}
}
\value{
A Dataframe with results for each variable of the model.
}
\description{
A tool for Environment-Wide Association Studies (EnvWAS / EWAS) namely repeated analyses allowing to estimate the relationships between several environmental factors and a health events. This function is especially for linear regressions and allows the addition of adjustment variables.
}
\examples{
### Loading the PIMA dataset contained in the mlbench package

library(mlbench)
data(PimaIndiansDiabetes)

### Using ELJAlinear to perform EWAS analysis

ELJAlinear(var = 'pregnant',data = PimaIndiansDiabetes,manplot = TRUE,
Bonferroni = TRUE,FDR = TRUE, nbvalmanplot = 30, manplotsign = FALSE)
results



}
\references{
Dunn OJ. Multiple Comparisons Among Means. Journal of the American Statistical Association. 1961;56(293):52‑64.
Benjamini Y, Hochberg Y. Controlling the False Discovery Rate: A Practical and Powerful Approach to Multiple Testing. Journal of the Royal Statistical Society: Series B (Methodological). 1995;57(1):289‑300.
MLBench · Distributed Machine Learning Benchmark. Available from: https://mlbench.github.io/
Smith JW, Everhart JE, Dickson WC, Knowler WC, Johannes RS. Using the ADAP Learning Algorithm to Forecast the Onset of Diabetes Mellitus. Proc Annu Symp Comput Appl Med Care. 1988 Nov 9;261–5.
}
