% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EllDistrEstDeriv.R
\name{compute_etahat}
\alias{compute_etahat}
\title{Compute \eqn{\hat{\eta}_k}}
\usage{
compute_etahat(
  X,
  mu = 0,
  Sigma_m1 = diag(d),
  grid,
  h,
  Kernel = "gaussian",
  a = 1,
  k,
  mpfr = FALSE,
  precBits = 100,
  dopb = TRUE
)
}
\arguments{
\item{X}{a matrix of size \eqn{n \times d}, assumed to be \eqn{n} i.i.d. observations
(rows) of a \eqn{d}-dimensional elliptical distribution.}

\item{mu}{mean of X. This can be the true value or an estimate. It must be
a vector of dimension \eqn{d}.}

\item{Sigma_m1}{inverse of the covariance matrix of X.
This can be the true value or an estimate. It must be
a matrix of dimension \eqn{d \times d}.}

\item{grid}{grid of values on which to estimate the density generator.}

\item{h}{bandwidth of the kernel. Can be either a number or a vector of the
size \code{length(grid)}.}

\item{Kernel}{name of the kernel. Possible choices are
\code{"gaussian"}, \code{"epanechnikov"}, \code{"triangular"}.}

\item{a}{tuning parameter to improve the performance at 0.}

\item{k}{order of the derivative}

\item{mpfr}{if \code{mpfr = TRUE}, multiple precision floating point is used
via the package \link[Rmpfr:Rmpfr]{Rmpfr}.
This allows for a higher (numerical) accuracy, at the expense of computing time.
It is recommended to use this option for higher dimensions.}

\item{precBits}{number of precBits used for floating point precision
(only used if \code{mpfr = TRUE}).}

\item{dopb}{a Boolean value.
If \code{dopb = TRUE}, a progress bar is displayed.}
}
\value{
a vector of size \code{n1 = length(grid)}.
Each component of this vector is \eqn{\hat{\eta}_k(x[i])}
where \code{x[i]} is the \eqn{i}-th element of the grid.
}
\description{
\eqn{\hat{\eta}_k} is a quantity that is useful
for estimating the \eqn{k}-th derivative of the generator
of an elliptical distribution.
It is defined in Section 3 of (Ryan and Derumigny, 2024).
}
\examples{

if (FALSE){
# Comparison between the estimated and true generator of the Gaussian distribution
n = 500000
d = 3
X = matrix(rnorm(n * d), ncol = d)
grid = seq(0, 5, by = 0.1)
a = 0.7

etahat = compute_etahat(X = X, grid = grid, a = a, h = 0.04, k = 1)
plot(grid, etahat, type = "l", ylim = c(-0.02, 0.02))

# Computation of true values
g = exp(-grid/2)/(2*pi)^{3/2}
gprime = (-1/2) *exp(-grid/2)/(2*pi)^{3/2}
A = a^(d/2)
psia = -a + (A + grid^(d/2))^(2/d)
psiaprime = grid^(d/2 - 1) * (A + grid^(d/2))^(2/d - 1)
psiasecond = psiaprime * ( (d-2)/2 ) * grid^{-1} * A *
  ( grid^(d/2) + A )^(-1)

rhoprimexi = ((d-2) * grid^((d-4)/2) * psiaprime
- 2 * grid^((d-2)/2) * psiasecond) / (2 * psiaprime^3) * g +
grid^((d-2)/2) / (psiaprime^2) * gprime

lines(grid, rhoprimexi, col = "red")
}

}
\author{
Victor Ryan, Alexis Derumigny
}
\keyword{internal}
