% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{poussin}
\alias{poussin}
\title{Poussin: weight by brooding temperature and sex}
\format{
A data frame with 45 rows and 3 variables:
\describe{
  \item{Temperature}{factor with 3 levels: "T1", "T2", "T3" (15 each).}
  \item{Gender}{factor with 2 levels: "Female", "Male" (about 20 and 25).}
  \item{Weight}{numeric; weight (units as provided).}
}
}
\usage{
data(poussin)
}
\description{
Chick weights measured under three brooding temperatures, with sex recorded.
Useful for ANOVA and linear models with categorical factors.
}
\details{
Brief summary (indicative): Weight min ~ 15, median ~ 23, max ~ 33.
}
\examples{
data(poussin)
with(poussin, table(Temperature, Gender))
boxplot(Weight ~ Temperature, data = poussin,
        main = "Poussin weight by temperature")
# Two-factor ANOVA (base stats):
fit <- stats::aov(Weight ~ Temperature * Gender, data = poussin)
summary(fit)

}
\keyword{datasets}
