% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_epidemic_probability.R
\name{calculate_epidemic_probability}
\alias{calculate_epidemic_probability}
\title{Main function for calculating epidemic probability}
\usage{
calculate_epidemic_probability(
  numberInsects,
  start_intervl = (1/10),
  localParameters,
  virusParameters,
  thresh = 10^(-7)
)
}
\arguments{
\item{numberInsects}{Numeric: number of insect vectors per plant (required).}

\item{start_intervl}{Numeric: initial guess for expected time in hours until next event (optional, default = 0.1). This is fine-tuned from within the function. Needed to calculate efficient time step i.e. largest value such that sum of probabilities of individual events < 1.}

\item{localParameters}{A numeric vector of length 5 corresponding to event rates (day^-1) (required):
The first element specifies the Vector dispersal rate,
the second the Roguing rate,
the third the Vector mortality rate,
the forth the Harvesting rate,
the fifth the Plant latent progression rate}

\item{virusParameters}{Numeric vector of length 3 specifying virus parameters (day^-1) (required):
\describe{
\item{\code{[1]}}{Acquisition rate.}
\item{\code{[2]}}{Inoculation rate.}
\item{\code{[3]}}{Insect recovery rate.}
}}

\item{thresh}{Numeric: equilibrium condition for extinction probability (optional, default = 10^(-7)). If no inoculum state changes by more than thresh in a timestep then function assumes extinction probability has stabilised.}
}
\value{
Numeric vector of length n: epidemic probability for each of n inoculum states (where n=(numberInsects+1)*3-1).

\strong{Preprint reference}

The models implemented in this function follow Donnelly et al. (2025, preprint), originally implemented in the EpiPv GitHub package.
}
\description{
This function calculates epidemic probability from viral and local parameters according to inoculum state (calling the helper function solveInoculumStatesBP.r to calculate transition and fertility matrices)
}
\examples{
qm_out=calculate_epidemic_probability(
    numberInsects=3,start_intervl=(1/10),
    localParameters=rep(0.1,5),
    virusParameters=rep(0.1,3),thresh=10^(-7)
)
}
\references{
Donnelly, R., Tankam, I. & Gilligan, C. (2025).
"Plant pathogen profiling with the EpiPv package."
EcoEvoRxiv, \doi{10.32942/X29K9P}.

When available, please cite the published version.
}
