% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmm2_monte_carlo.R
\name{pmm2_monte_carlo_compare}
\alias{pmm2_monte_carlo_compare}
\title{Monte Carlo comparison of PMM2 estimation methods}
\usage{
pmm2_monte_carlo_compare(
  model_specs,
  methods = c("css", "pmm2"),
  n,
  n_sim,
  innovations = list(type = "gaussian"),
  seed = NULL,
  include.mean = TRUE,
  progress = interactive(),
  verbose = FALSE
)
}
\arguments{
\item{model_specs}{List of model specifications. Each element must contain:
\describe{
\item{model}{"ar", "ma" or "arma"}
\item{order}{order (for AR/MA) or vector c(p, q) for ARMA}
\item{theta}{numeric vector of true parameters; for ARMA a list
\code{list(ar = ..., ma = ...)}}
\item{label}{(optional) model name in report}
\item{innovations}{(optional) description of innovation distribution:
\code{list(type = "gamma", shape = 2)},
\code{list(type = "student_t", df = 5)}, etc. Can also
pass an arbitrary generation function via \code{generator}.}
}}

\item{methods}{Vector of estimation methods (e.g., \code{c("css","pmm2")}).
The first method is considered baseline for relative MSE calculation.}

\item{n}{Sample size for simulation.}

\item{n_sim}{Number of Monte Carlo experiments.}

\item{innovations}{Function or distribution description, used by
default for all models (if not specified in spec).}

\item{seed}{Initial seed for random number generator (optional).}

\item{include.mean}{Logical flag: whether to include intercept during estimation.}

\item{progress}{Logical flag: print Monte Carlo progress.}

\item{verbose}{Whether to print diagnostic messages on failures.}
}
\value{
List with three components:
\describe{
\item{parameter_results}{MSE and relative MSE for each parameter}
\item{summary}{Averaged MSE over parameters for each model/method}
\item{gain}{Comparison of theoretical and empirical PMM2 gain}
}
}
\description{
Function generates time series for given models, repeatedly estimates
parameters using different methods and compares their accuracy by MSE criterion.
Additionally outputs theoretical and empirical characteristics of the innovation
distribution (skewness, excess kurtosis, theoretical gain of PMM2).
}
