% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eng_eviews.R
\name{eng_eviews}
\alias{eng_eviews}
\title{EviewsR: A Seamless Integration of R and EViews}
\usage{
eng_eviews(options)
}
\arguments{
\item{options}{Chunk options, as provided by \code{knitr} during chunk execution. Chunk option for this is \code{eviews}}
}
\value{
Set of \code{EViews} codes
}
\description{
This package runs on top of knitr to facilitate communication with EViews. Run EViews scripts from R Markdown document.
}
\details{
The \code{EViews} engine can be activated via

\if{html}{\out{<div class="sourceCode">}}\preformatted{knitr::knit_engines$set(eviews = EviewsR::eng_eviews)
}\if{html}{\out{</div>}}

This will be set within an R Markdown document's setup chunk.
}
\examples{
knitr::knit_engines$set(eviews = EviewsR::eng_eviews)
library(EviewsR)
}
\references{
Mati, Sagiru. 2020a. “DynareR: Bringing the Power of Dynare to R, R Markdown, and Quarto.” CRAN. https://CRAN.R-project.org/package=DynareR.

Mati, Sagiru. 2020b. EviewsR: A Seamless Integration of EViews and R. \url{https://CRAN.R-project.org/package=EviewsR}.

Mati, Sagiru. 2020c. gretlR: A Seamless Integration of Gretl and R. \url{https://CRAN.R-project.org/package=gretlR}.

Mati, Sagiru. 2023b. URooTab: Tabular Reporting of EViews Unit Root Tests. \url{https://CRAN.R-project.org/package=URooTab}.

Mati, Sagiru, Irfan Civcir, and S. I. Abba. 2023. “EviewsR: An r Package for Dynamic and Reproducible Research Using EViews, R, R Markdown and Quarto.” The R Journal 15 (2): 169–205. \url{doi:10.32614/RJ-2023-045}.

Bob Rudis (2015).Running Go language chunks in R Markdown (Rmd) files. Available at:  https://gist.github.com/hrbrmstr/9accf90e63d852337cb7

Yihui Xie (2019). knitr: A General-Purpose Package for Dynamic Report Generation in R. R package version 1.24.

Yihui Xie (2015) Dynamic Documents with R and knitr. 2nd edition. Chapman and Hall/CRC. ISBN 978-1498716963

Yihui Xie (2014) knitr: A Comprehensive Tool for Reproducible Research in R. In Victoria Stodden, Friedrich Leisch and Roger D. Peng, editors, Implementing Reproducible Computational Research. Chapman and Hall/CRC. ISBN 978-1466561595
#insertAllCited{}
}
\seealso{
Other important functions: 
\code{\link{EviewsR-package}},
\code{\link{create_object}()},
\code{\link{eviews_graph}()},
\code{\link{eviews_import}()},
\code{\link{eviews_pagesave}()},
\code{\link{eviews_wfcreate}()},
\code{\link{eviews_wfsave}()},
\code{\link{exec_commands}()},
\code{\link{export}()},
\code{\link{export_dataframe}()},
\code{\link{import}()},
\code{\link{import_equation}()},
\code{\link{import_graph}()},
\code{\link{import_kable}()},
\code{\link{import_series}()},
\code{\link{import_table}()},
\code{\link{import_workfile}()},
\code{\link{rwalk}()},
\code{\link{set_eviews_path}()}
}
\author{
Sagiru Mati, ORCID: \href{https://orcid.org/0000-0003-1413-3974}{0000-0003-1413-3974}, \url{https://smati.com.ng}
\itemize{
\item Northwest University Kano, Nigeria
\item SMATI Academy
}
}
\concept{important functions}
