% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPDM.R
\name{svd.tpdm}
\alias{svd.tpdm}
\title{Singular Value decomposition for cross-TPDM}
\usage{
svd.tpdm(Sigma, X, Y)
}
\arguments{
\item{Sigma}{A n x n data array, containing the cross-TPDM, can be output of \link{est.tpdm}.}

\item{X}{A t x n dimensional, numeric Data-matrix with t: Number of time steps and n: Number of grid points/stations.}

\item{Y}{Same as X but for second variable.}
}
\value{
List containing
\itemize{
    \item pcU, pcV: The left- and right expansion coefficients of cross-TPDM
    \item U, V: The left- and right singular Vectors of cross-TPDM
    \item extr.U, extr.V: The left- and right singular vectors of cross-TPDM, but transformed in positive reals with \link{trans}
}
}
\description{
Calculates singular value decomposition (SVD) of given cross-TPDM
}
