% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fabtzCI.R
\name{fabtzCI}
\alias{fabtzCI}
\title{z-optimal FAB t-interval}
\usage{
fabtzCI(y, s, dof, alpha = 0.05, psi = list(mu = 0, tau2 = 1e+05,
  sigma2 = 1))
}
\arguments{
\item{y}{a numeric scalar, a normally distributed statistic}

\item{s}{a numeric scalar, the standard error of y}

\item{dof}{positive integer, degrees of freedom for s}

\item{alpha}{the type I error rate, so 1-alpha is the coverage rate}

\item{psi}{a list of parameters for the spending function, including 
\enumerate{
\item mu, the prior expectation of E[y]
\item tau2, the prior variance of E[y]
\item sigma2 the variance of y
}}
}
\value{
a two-dimensional vector of the left and right endpoints of the interval
}
\description{
Computation of a 1-alpha FAB t-interval using 
z-optimal spending function
}
\examples{
n<-10 
y<-rnorm(n) 
fabtzCI(mean(y),sqrt(var(y)/n),n-1)  
t.test(y)$conf.int 
}
\author{
Peter Hoff
}
