% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplesize.R
\name{fdr.power.alpha}
\alias{fdr.power.alpha}
\title{Compute FDR for given p-value threshold, average power and proportion of tests with a true null}
\usage{
fdr.power.alpha(alpha, pwr, pi0, method = "HH")
}
\arguments{
\item{alpha}{p-value threshold (vector)}

\item{pwr}{average power}

\item{pi0}{actual proportion of tests with a true null hypothesis}

\item{method}{method to estimate proportion \code{pi0} of tests with true null, including: "HH" (p-value histogram height), "HM" (p-value histogram mean), "BH" (Benjamini & Hochberg 1995), "Jung" (Jung 2005)}
}
\value{
FDR
}
\description{
Compute the FDR for given values of the p-value threshold alpha, average power, and proportion pi0 of tests with a true null hypothesis.
}
\examples{
alpha = 1:100/1000;
pwr = rep(0.8,length(alpha));
pi0 = 0.95;
fdr.power.alpha(alpha,pwr,pi0,method="HH")
}
\references{
Pounds S and Cheng C, "Sample size determination for the false discovery rate." Bioinformatics 21.23 (2005): 4263-4271.

Gadbury GL, et al. (2004) Power and sample size estimation in high dimensional biology. Statistical Methods in Medical Research 13(4):325-38.

Jung,Sin-Ho."Sample size for FDR-control in microarray data analysis." Bioinformatics 21.14 (2005): 3097-3104.

Ni Y, Seffernick A, Onar-Thomas A, Pounds S.  "Computing Power and Sample Size for the False Discovery Rate in Multiple Applications", Manuscript.
}
