% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoAdjust.2d.R
\name{AutoAdjust.2d}
\alias{AutoAdjust.2d}
\title{AutoAdjust.2d}
\usage{
AutoAdjust.2d(meshP, meshT, edge, centroid, AspectR, AR)
}
\arguments{
\item{meshP}{Matrix (2 x n) containing coordinate points of the mesh nodes.}

\item{meshT}{Matrix (3 x n) containing the number of the coordinate point that forms a given triangle within the mesh.}

\item{edge}{Coordinate points of the initial geometry.}

\item{centroid}{Matrix (2 x n) of triangle elements.}

\item{AspectR}{Aspect ratio of each triangle element.}

\item{AR}{maximum desired aspect ratio, numeric value.}
}
\value{
Generates new mesh and centroid tables
\item{Meshpts}{Includes both new mesh coordinate points and triangulation of points.}
\item{Centroids}{Centroid positions for each triangle element.}
}
\description{
Allows for automatic refinement of the triangular mesh generated based on given parameters. Will remove elements that are outside the margin of the geometry.
}
\examples{
data(triMesh)
data(polyshape)
data(dime)

meshP = triMesh$MeshPts$p
meshT = triMesh$MeshPts$T
edge =  polyshape$Line
centroid = triMesh$Centroids
AspectR = dime$AspectRatio
AR = 10

auto = AutoAdjust.2d(meshP, meshT, edge, centroid, AspectR, AR)

}
