% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beamApplyBC.R
\name{beamApplyBC}
\alias{beamApplyBC}
\title{beamApplyBC}
\usage{
beamApplyBC(beamP, BCtran, BCrot)
}
\arguments{
\item{beamP}{Matrix (2 x n) of beam coordinates.}

\item{BCtran}{Boundary constraint for nodes to translate in x or y directions. Input as a non-matrix column.}

\item{BCrot}{Boundary constraint for nodes to rotate. Input as a non-matrix column.}
}
\value{
A data frame with constraint parameters applied to each node for directional translation and rotation. Formatted for use in reduced element matrix.
\item{NodeKnownL}{Matrix (1 x n) of constraint parameters}
}
\description{
Boundary constraint for element centroids based on coordinate points. For the x & y direction per centroid create matrix with boundary 1(unfixed) or 0(fixed).
}
\examples{
data(beamGeo)

beamBC = beamApplyBC(beamGeo$beamP, beamGeo$BCtran, beamGeo$BCrot)

}
