% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spread.R
\name{SwitchMargrabe}
\alias{SwitchMargrabe}
\title{Margrabe's formula for exhange option price}
\usage{
SwitchMargrabe(
  spot1,
  spot2,
  texp = 1,
  sigma1,
  sigma2,
  corr,
  intr = 0,
  divr1 = 0,
  divr2 = 0,
  cp = 1L,
  forward1 = spot1 * exp(-divr1 * texp)/df,
  forward2 = spot2 * exp(-divr2 * texp)/df,
  df = exp(-intr * texp)
)
}
\arguments{
\item{spot1}{(vector of) spot price of asset 1}

\item{spot2}{(vector of) spot price of asset 2}

\item{texp}{(vector of) time to expiry}

\item{sigma1}{(vector of) volatility of asset 1}

\item{sigma2}{(vector of) volatility of asset 2}

\item{corr}{correlation}

\item{intr}{interest rate}

\item{divr1}{dividend rate of asset 1}

\item{divr2}{dividend rate of asset 2}

\item{cp}{call/put sign. \code{1} for call, \code{-1} for put.}

\item{forward1}{forward price of asset 1. If given, overrides \code{spot1}}

\item{forward2}{forward price of asset 2. If given, overrides \code{spot2}}

\item{df}{discount factor. If given, \code{df} overrides \code{intr}}
}
\value{
option price
}
\description{
The payout of the exchange option is
  \code{max(S1_T - S2_T, 0)} where \code{S1_T} and \code{S2_T} are the
  prices at expiry \code{T} of assets 1 and 2 respectively.
}
\examples{

FER::SwitchMargrabe(100, 120, 1.3, 0.2, 0.3, -0.5)

}
\references{
Margrabe, W. (1978). The value of an option to exchange one
  asset for another. The Journal of Finance, 33(1), 177–186.
}
\seealso{
\code{\link{SpreadKirk}}
}
