% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_funs.R
\name{summary.ame}
\alias{summary.ame}
\alias{print.summary.ame}
\title{Summarize the output of FLAME or DAME}
\usage{
\method{summary}{ame}(object, ...)

\method{print}{summary.ame}(x, digits = 3, ...)
}
\arguments{
\item{object}{An object of class \code{ame}, returned by a call to
\code{\link{FLAME}} or \code{\link{DAME}}}

\item{...}{Additional arguments to be passed on to other methods.}

\item{x}{An object of class \code{summary.ame}, returned by a call to
\code{\link{summary.ame}}}

\item{digits}{Number of significant digits for printing the average treatment
effect estimates and their variances.}
}
\value{
A list of type \code{summary.ame} with the following entries:
\describe{
\item{MG}{
  A list with the number and median size of matched groups formed.
  Additionally, two of the highest quality matched groups formed. Quality
  is determined first by number of covariates matched on and second by
  matched group size.
 }
\item{n_matches}{
  A matrix detailing the number of treated and control units matched.
 }
\item{TEs}{
  If the matching data had a continuous outcome, estimates of the ATE, ATT,
  and ATC and the corresponding variance of the estimates.
 }
}
}
\description{
These methods create and print objects of class \code{summary.ame} containing
information on the numbers of units matched by the AME algorithm, matched
groups formed, and, if applicable, average treatment effects.
}
\details{
The average treatment effect (ATE) is estimated as the average CATE estimate
across all matched units in the data, while the average treatment effect on
the treated (ATT) and average treatment effect on controls (ATC) average only
across matched treated or matched control units, respectively. Variances of
these estimates are computed as in Abadie, Drukker, Herr, and Imbens (The
Stata Journal, 2004) assuming constant treatment effect and homoscedasticity.
Note that the implemented estimator is \strong{not} =asymptotically normal
and so in particular, asymptotically valid confidence intervals or hypothesis
tests cannot be conducted on its basis. In the future, the estimation
procedure will be changed to employ the nonparametric regression bias
adjustment estimator of Abadie and Imbens 2011 which is asymptotically
normal.
}
