% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simu.R
\name{simu}
\alias{simu}
\title{Simulate data following log-ratio model}
\usage{
simu(
  n = 100,
  p = 200,
  model = "linear",
  weak = 4,
  strong = 6,
  weaksize = 0.125,
  strongsize = 0.25,
  pct.sparsity = 0.5,
  rho = 0,
  timedep_slope = NULL,
  timedep_cor = NULL,
  geetype = "gaussian",
  m = 4,
  corstr = "exchangeable",
  sdvec = NULL,
  rhogee = 0.8,
  geeslope = 2.5,
  longitudinal_stability = TRUE,
  ncov = 0,
  betacov = 0,
  intercept = FALSE
)
}
\arguments{
\item{n}{An integer of sample size}

\item{p}{An integer of number of features (taxa).}

\item{model}{Type of models associated with outcome variable, can be "linear", "binomial", "cox", "finegray", "gee" (scalar outcome with time-dependent features), or "timedep" (survival endpoint with time-dependent features).}

\item{weak}{Number of features with \code{weak} effect size.}

\item{strong}{Number of features with \code{strong} effect size.}

\item{weaksize}{Actual effect size for \code{weak} effect size. Must be positive.}

\item{strongsize}{Actual effect size for \code{strong} effect size. Must be positive.}

\item{pct.sparsity}{Percentage of zero counts for each sample.}

\item{rho}{Parameter controlling the correlated structure between taxa. Ranges between 0 and 1.}

\item{timedep_slope}{If \code{model} is "timedep", this parameter specifies the slope for the feature trajectories. Please refer to the Simulation section of the manuscript for more details.}

\item{timedep_cor}{If \code{model} is "timedep", this parameter specifies the sample-wise correlations between longitudinal features. Please refer to the Simulation section of the manuscript for more details.}

\item{geetype}{If \code{model} is "gee", \code{geetype} is the type of GEE outcomes. Now support "gaussian" and "binomial".}

\item{m}{If \code{model} is "gee", \code{m} is the number of repeated measurements per subject.}

\item{corstr}{If \code{model} is "gee", \code{corstr} is the working correlation structure. Now support "independence", "exchangeable", and "AR-1".}

\item{sdvec}{If \code{model} is "gee" and \code{geetype} is "gaussian", \code{sdvec} is the vector of standard deviations of each outcome variable.}

\item{rhogee}{If \code{model} is "gee", \code{rhogee} is the correlation parameter between longitudinal outcomes under the selected working correlation structure.}

\item{geeslope}{If \code{model} is "gee", \code{geeslope} is the linear time effect.}

\item{longitudinal_stability}{If \code{model} is "timedep", this is a binary indicator which determines whether the trajectories are more stable (\code{TRUE}) or more volatile (\code{FALSE}).}

\item{ncov}{Number of covariates that are not compositional features.}

\item{betacov}{Coefficients corresponding to the covariates that are not compositional features.}

\item{intercept}{Boolean. If TRUE, then a random intercept will be generated in the model. Only works for \code{linear} or \code{binomial} models.}
}
\value{
A list with simulated count matrix \code{xcount}, log1p-transformed count matrix \code{x}, outcome (continuous \code{y}, continuous centered \code{y0}, binary \code{y}, or survival \code{t}, \code{d}), true coefficient vector \code{beta}, list of non-zero features \code{idx}, value of intercept \code{intercept} (if applicable).
}
\description{
Simulate a dataset from log-ratio model.
}
\examples{

set.seed(23420)
dat <- simu(n=50,p=30,model="linear")

}
\references{
Fei T, Funnell T, Waters N, Raj SS et al. Enhanced Feature Selection for Microbiome Data using FLORAL: Scalable Log-ratio Lasso Regression bioRxiv 2023.05.02.538599.
}
\author{
Teng Fei. Email: feit1@mskcc.org
}
