% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approximatesmoothC++.R
\name{approx.smooth}
\alias{approx.smooth}
\title{Approximate the smoothing distribution of a Fleming-Viot latent signal}
\usage{
approx.smooth(fvddp.past, fvddp.future, t.past, t.future, y.new, N)
}
\arguments{
\item{fvddp.past}{An instance of class \code{fvddp}, progressively updated ad propagated
with data referring to past times via \code{\link[=update]{update()}} and \code{\link[=propagate]{propagate()}}
(or its approximate version, \code{\link[=approx.propagate]{approx.propagate()}}).}

\item{fvddp.future}{Same as \code{fvddp.past}, but in this case the propagation has
been performed with time data from times later than the one to be estimated. Its
hyperparameters must be equals to the ones of \code{fvddp.past}.}

\item{t.past}{The time between the last collection of data (in the past) and the
time at which the smoothing is performed.}

\item{t.future}{Same as \code{t.past}, but in this case it is referred to the future.
\code{t.future} is positive too.}

\item{y.new}{The data collected at the time the smoothing is performed.}

\item{N}{the amount of samples to be drawn in order to perform the approximation.}
}
\value{
An object of class \code{fvddp}, with the same hyperparmeters as \code{fvddp.past}
and \code{fvddp.future}. Since this function is a Monte-Carlo based
approximation of \code{\link[=smooth]{smooth()}}, the outputs are similar.
}
\description{
Approximate the smoothing distribution of a Fleming-Viot latent signal
}
\examples{
FVDDP = initialize(3, function(x) rbinom(x, 10, .2),
                   function(x) dbinom(x, 10, .2), TRUE)
FVDDP.PAST = update(FVDDP, c(2,3))
FVDDP.FUTURE = update(FVDDP, c(4))
FVDDP.FUTURE = propagate(FVDDP.FUTURE, 0.5)
FVDDP.FUTURE = update(FVDDP.FUTURE, c(1))
approx.smooth(fvddp.past = FVDDP.PAST, fvddp.future = FVDDP.FUTURE,
              t.past = 0.4, t.future = 0.3, y.new = c(1,3), N = 20000)

}
\seealso{
\code{\link[=smooth]{smooth()}} for a (slower) exact computation
}
