% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_frm}
\alias{plot_frm}
\title{Plot predictions for a FastRet model}
\usage{
plot_frm(frm = train_frm(verbose = 1), type = "scatter.cv", trafo = "identity")
}
\arguments{
\item{frm}{An object of class \code{frm} as returned by \code{\link[=train_frm]{train_frm()}}.}

\item{type}{Plot type. One of:
\itemize{
\item "scatter.cv": CV predictions for the training set
\item "scatter.cv.adj": CV predictions for the adjustment set (requires \code{frm$adj})
\item "scatter.train": Model predictions for the training set
\item "scatter.train.adj": Adjusted model predictions for the adjustment set (requires \code{frm$adj})
}}

\item{trafo}{Transformation applied for display. One of:
\itemize{
\item "identity": no transformation
\item "log2": apply log2 transform to axes (metrics are computed on raw values)
}}
}
\value{
NULL, called for its side effect of plotting.
}
\description{
Creates scatter plots of measured vs. predicted retention times (RT) for a
FastRet Model (FRM). Supports plotting cross-validation (CV) predictions and
fitted predictions on the training set, as well as their adjusted variants
when the model has been adjusted via \code{\link[=adjust_frm]{adjust_frm()}}. Coloring highlights
points within 1 minute of the identity line and simple outliers.
}
\examples{
frm <- read_rp_lasso_model_rds()
plot_frm(frm, type = "scatter.cv")
}
\keyword{public}
