% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaProgramming.R
\name{evalText}
\alias{evalText}
\title{evaluates a string as R code, and stops if an error occurs}
\usage{
evalText(..., envir = parent.frame())
}
\arguments{
\item{...}{the R code to evaluate as characters. Will be joined when
evaluating.}

\item{envir}{the environment in which to evaluate the code. Defaults to the
parent frame of the function.}
}
\value{
the result of the evaluation
}
\description{
This function evaluates a string as R code, and stops if an error occurs.
This can be useful for evaluating code that is generated dynamically.
}
\examples{
# Set names of a vector
x <- 1:3
x <- evalText("setNames(x, c('A', 'B', 'C'))")
x

}
\keyword{metaProgramming}
