% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indexing.R
\name{getfirst}
\alias{getfirst}
\alias{getfirst.default}
\title{Get the First Elements of a Vector or List}
\usage{
getfirst(x, n = 1)

\method{getfirst}{default}(x, n = 1)
}
\arguments{
\item{x}{A vector, list, or other supported data type.}

\item{n}{An integer specifying the number of elements to retrieve from the
start. Default is 1.}
}
\value{
The first \code{n} elements of the input.
}
\description{
This function retrieves the first \code{n} elements of a vector or list.
}
\examples{
# Get the first element of a vector
getfirst(c(1, 2, 3, 4, 5))
# Get the first 2 elements of a vector
getfirst(c(1, 2, 3, 4, 5), 2)
# Get the first element of a list
getfirst(list("a", "b", "c"))
# Get the first 2 elements of a list
getfirst(list("a", "b", "c"), 2)
}
\keyword{indexing}
