% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04.FF_either.R
\name{FF.binary.management}
\alias{FF.binary.management}
\title{Create a binary firm-firm (FF) matrix for board interlocks}
\usage{
FF.binary.management(
  ...,
  id_as_firm_name = NULL,
  Matrix = NULL,
  self_ties = FALSE
)
}
\arguments{
\item{...}{Either multiple objects of class \code{firm} or a list of such objects}

\item{id_as_firm_name}{Whether to use the ticker as the firm's name. Defaults to \code{TRUE} if all firms' id is neither \code{NULL} nor \code{NA}.}

\item{Matrix}{Whether to use the \href{https://cran.r-project.org/package=Matrix}{\code{Matrix} package}. Defaults to \code{TRUE} when any matrix in the pipeline contains more than 10,000 cells and the package is installed.}

\item{self_ties}{Whether to allow self-ties (a 'loop' in graph theory). Defaults to \code{FALSE}.}
}
\value{
A matrix object of class \code{financial_matrix}(possibly using the \href{https://cran.r-project.org/package=Matrix}{\code{Matrix} package})
}
\description{
Function to create a binary firm-firm (FF) matrix based on board interlocks
}
\examples{

# Create the binary FF matrix of Berkshire Hathaway's holdings by boards interlock
data('firms_BKB')
FF <- FF.binary.management(firms_BKB)


}
\seealso{
Other Financial_matrix builders: 
\code{\link{FF}()},
\code{\link{FF.binary.both}()},
\code{\link{FF.binary.ownership}()},
\code{\link{FF.naive.both}()},
\code{\link{FF.naive.management}()},
\code{\link{FF.naive.ownership}()},
\code{\link{FF.norm.both}()},
\code{\link{FF.norm.management}()},
\code{\link{FF.norm.ownership}()}
}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
\concept{Financial_matrix builders}
