% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whichFishAdd.R
\name{whichFishAdd}
\alias{whichFishAdd}
\title{Function to inform which species must be added to the mega-tree phylogeny in the insertion process.}
\usage{
whichFishAdd(data)
}
\arguments{
\item{data}{A data frame with three column containing the name of species (s), the Family (f) and Order (o). This
can be generated with function \code{\link{FishTaxaMaker}}}
}
\value{
A data frame containing a column informing at which level the species in data must be added.
}
\description{
Function to inform which species must be added to the mega-tree phylogeny in the insertion process.
}
\details{
This function can be used  in order to known which species that must be added in the insertion process
made by \code{\link{FishPhyloMaker}}.
}
\examples{
\donttest{
    data("taxon_data_PhyloMaker")
    res_test <- whichFishAdd(data = taxon_data_PhyloMaker)
}


}
