% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDistUlt.R
\name{FDistUlt}
\alias{FDistUlt}
\title{Fits a set of observations (random variable) to test whether is drawn from a certain distribution}
\usage{
FDistUlt(X, n.obs = length(X), ref = "OP", crt = 1, plot = FALSE,
  subplot = FALSE, p.val_min = 0.05)
}
\arguments{
\item{X}{A random sample to be fitted.}

\item{n.obs}{A positive integer, is the length of the random sample to be generated}

\item{ref}{Aumber of clusters to use by the kmeans function to split the distribution, if isn't a number, uses mclust classification by default.}

\item{crt}{Criteria to be given to FDist() function}

\item{plot}{FALSE. If TRUE, generates a plot of the density function.}

\item{subplot}{FALSE. If TRUE, generates the plot of the mixed density function's partitions.}

\item{p.val_min}{Minimum p.value to be given to non-reject the null hypothesis.}
}
\value{
A list with the density functions, a random sample, a  data frame with the KS and AD p.values results, the corresponding plots an the random numbers generator functions
}
\description{
Fits a set of observations (random variable) to test whether is drawn from a certain distribution
}
\examples{

set.seed(31109)
X<-c(rnorm(193,189,12),rweibull(182,401,87),rgamma(190,40,19))

A_X<-FDistUlt(X,plot=TRUE,subplot=TRUE)

A_X<-FDistUlt(X,plot=TRUE,subplot=TRUE,p.val_min=.005)

# Functions generated
A_X[[1]][[1]]()
# Random sample
A_X[[2]]

#Distributions
A_X[[3]]

# Plots
par(mfrow=c(1,2))
A_X[[4]][[1]]
A_X[[4]][[2]]

# More functions
A_X[[5]][[1]]()


}
