% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proj_matrix.R
\name{teprojmat}
\alias{teprojmat}
\title{Projection matrix for optimal combination temporal reconciliation}
\usage{
teprojmat(agg_order, comb = "ols", res = NULL, mat = "M", tew = "sum", ...)
}
\arguments{
\item{agg_order}{Highest available sampling frequency per seasonal cycle (max. order
of temporal aggregation, \eqn{m}), or a vector representing a subset of \eqn{p} factors
of \eqn{m}.}

\item{comb}{A string specifying the reconciliation method. For a complete list, see \link{tecov}.}

\item{res}{A (\eqn{N(k^\ast+m) \times 1}) optional numeric vector containing the
in-sample residuals at all the temporal frequencies ordered from the lowest frequency
to the highest frequency. This vector is used to compute come covariance matrices.}

\item{mat}{A string specifying which matrix to return:
"\code{M}" (\emph{default}) for \eqn{\mathbf{M}} and "\code{G}" for \eqn{\mathbf{G}}.}

\item{tew}{A string specifying the type of temporal aggregation. Options include:
"\code{sum}" (simple summation, \emph{default}), "\code{avg}" (average),
"\code{first}" (first value of the period), and "\code{last}"
(last value of the period).}

\item{...}{
  Arguments passed on to \code{\link[=tecov]{tecov}}
  \describe{
    \item{\code{mse}}{If \code{TRUE} (\emph{default}) the residuals used to compute the covariance
matrix are not mean-corrected.}
    \item{\code{shrink_fun}}{Shrinkage function of the covariance matrix, \link{shrink_estim} (\emph{default})}
  }}
}
\value{
The projection matrix \eqn{\mathbf{M}} (\code{mat = "M"}) or
the mapping matrix \eqn{\mathbf{G}} (\code{mat = "G"}).
}
\description{
This function computes the projection or the mapping matrix
\eqn{\mathbf{M}} and \eqn{\mathbf{G}}, respectively, such that
\eqn{\widetilde{\mathbf{y}} = \mathbf{M}\widehat{\mathbf{y}} = \mathbf{S}_{te}\mathbf{G}\widehat{\mathbf{y}}},
where \eqn{\widetilde{\mathbf{y}}} is the vector of the reconciled forecasts,
\eqn{\widehat{\mathbf{y}}} is the vector of the base forecasts,
\eqn{\mathbf{S}_{te}} is the temporal structural matrix, and \eqn{\mathbf{M} = \mathbf{S}_{te}\mathbf{G}}.
For further information regarding on the structure of these matrices,
refer to Girolimetto et al. (2023).
}
\examples{
# Temporal framework (annual-quarterly)
Mte <- teprojmat(agg_order = 4, comb = "ols")
Gte <- teprojmat(agg_order = 4, comb = "ols", mat = "G")

}
\references{
Girolimetto, D., Athanasopoulos, G., Di Fonzo, T. and Hyndman, R.J. (2024),
Cross-temporal probabilistic forecast reconciliation: Methodological and
practical issues. \emph{International Journal of Forecasting}, 40, 3, 1134-1151.
\doi{10.1016/j.ijforecast.2023.10.003}
}
\seealso{
Utilities: 
\code{\link{FoReco2matrix}()},
\code{\link{aggts}()},
\code{\link{balance_hierarchy}()},
\code{\link{commat}()},
\code{\link{csprojmat}()},
\code{\link{cstools}()},
\code{\link{ctprojmat}()},
\code{\link{cttools}()},
\code{\link{df2aggmat}()},
\code{\link{lcmat}()},
\code{\link{recoinfo}()},
\code{\link{res2matrix}()},
\code{\link{set_bounds}()},
\code{\link{shrink_estim}()},
\code{\link{shrink_oasd}()},
\code{\link{tetools}()},
\code{\link{unbalance_hierarchy}()}
}
\concept{Utilities}
