% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_aggregated_curve.R
\name{plot_aggregated_curve}
\alias{plot_aggregated_curve}
\title{Aggregated Curve Plot}
\usage{
plot_aggregated_curve(alpha, weights, title = NULL, x = NULL)
}
\arguments{
\item{alpha}{A numeric matrix where each column represents the values of a function \eqn{\alpha_l(x)} evaluated at each point in \eqn{x}.}

\item{weights}{A numeric vector with the weight values corresponding to each function \eqn{\alpha_l(x)}.}

\item{title}{A string specifying the title of the plot.}

\item{x}{A numeric vector of values at which the function is evaluated. If \code{NULL}, the default is the sequence \code{1:nrow(alpha)}.}
}
\value{
The function returns the plot of the aggregated function.
}
\description{
Generates the plot of the aggregated curve based on the functional coefficients and their corresponding weights.
The aggregated curve is computed as:

\deqn{A(x) = \displaystyle \sum_{l=1}^{L} y_l \alpha_l(x)}
}
\examples{
plot_aggregated_curve(simulated_data$alphas, c(0.7, 0.3))
plot_aggregated_curve(simulated_data$alphas, c(0.7, 0.3),
                      "Aggregated Curve Example", simulated_data$x)

}
