% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMinfer.R
\name{EMinfer}
\alias{EMinfer}
\title{Run a short EM on p-values to fit a 2-component Beta mixture}
\usage{
EMinfer(pvalues, pi0, pi1, alpha0, alpha1, max.it)
}
\arguments{
\item{pvalues}{Numeric vector of gene-level p-values in (0, 1].}

\item{pi0}{Mixing proportion for the null/background component (Z = 0).}

\item{pi1}{Mixing proportion for the alternative/signal component (Z = 1); typically \code{pi1 = 1 - pi0}.}

\item{alpha0}{Shape parameter of the null p-value distribution, modeled as \eqn{p \sim \mathrm{Beta}(\alpha_0, 1)} when Z = 0.
The common choice \code{alpha0 = 1} corresponds to a Uniform(0,1) null.}

\item{alpha1}{Shape parameter of the alternative/signal p-value distribution, modeled as \eqn{p \sim \mathrm{Beta}(\alpha_1, 1)} when Z = 1.
Values < 1 concentrate mass near 0 (enrichment of small p-values).}

\item{max.it}{Integer. Maximum number of EM iterations.}
}
\value{
A list with elements:
\describe{
  \item{alpha0}{Estimated null shape parameter.}
  \item{alpha1}{Estimated alternative shape parameter.}
  \item{pi}{Estimated mixing proportion for the signal component (pi1).}
  \item{post}{Posterior probabilities \eqn{P(Z=1 \mid p)} for each p-value.}
}
}
\description{
Fits a two-component mixture model to gene-level p-values where
the null component is typically Uniform(0,1) (i.e., Beta(1,1)) and
the alternative component is Beta(alpha1, 1) with alpha1 < 1 enriching small p-values.
Returns updated mixture parameters and posterior probabilities of belonging to the
signal (alternative) component.
}
\keyword{internal}
