% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RealizedEst_Option.R
\name{RealizedEst_Option}
\alias{RealizedEst_Option}
\title{Realized GARCH-Ito Model with Options}
\usage{
RealizedEst_Option(RV = RV, JV = NULL, NV = NULL, homogeneous = TRUE)
}
\arguments{
\item{RV}{Time series of daily realized volatilities.}

\item{JV}{Time series of daily jump variations,}

\item{NV}{Time series of daily volatilities estimated using option data}

\item{homogeneous}{Whether to assume homogeneous error in the linear regression model between conditional
volatility of the realized GARCH-Ito model and volatility estimated from the option data, default is TRUE.}
}
\value{
Estimated parameter values and daily conditional volatilities:
\describe{
\item{coefficients}{parameter estimates of the realized GARCH-Ito model}
\item{sigma}{daily conditional volatility estimates of the realized GARCH-Ito model}
\item{pred}{one-step-ahead predicted volatility value}
}
}
\description{
Estimate model parameters for the Realized GARCH-Ito Model with Options
}
\references{
Song, X., Kim, D., Yuan, H., Cui, X., Lu, Z., Zhou, Y., & Wang, Y. (2020).
Volatility Analysis with Realized GARCH-Ito Models. Journal of Econometrics, in press.
}
