% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consecutive_trial_change.R
\name{consecutive_trial_change}
\alias{consecutive_trial_change}
\title{Compare mean activity in consecutive trials}
\usage{
consecutive_trial_change(Dataframe, Trials, Time.period)
}
\arguments{
\item{Dataframe}{a GCaMP-format data frame or matrix}

\item{Trials}{range of trial numbers to be compared}

\item{Time.period}{range of time to be compared}
}
\value{
Data frame with the "Mean.Change" column representing differences in means between trial n and trial n + 1 for the user-inputted range of trials.
}
\description{
`consecutive_trial_change` finds the change in means between consecutive trials.
}
\examples{
### How much did the mean value change after epoc between consecutive trials in trials 1-10?
df.new <- format_data(data = GCaMP)
consecutive_trial_change(Dataframe = df.new, Trials = c(1, 10), Time.period = c(0, 4))
}
