% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align_peaks_fast.R
\name{align_peaks_fast}
\alias{align_peaks_fast}
\title{align peaks individually among chromatograms}
\usage{
align_peaks_fast(gc_peak_list, rt_col_name)
}
\arguments{
\item{gc_peak_list}{List of data.frames. Each data.frame contains GC-data
(e.g. retention time, peak area, peak height) of one sample. Variables are
stored in columns. Rows represent distinct peaks. Retention time is a
required variable.}

\item{rt_col_name}{A character giving the name of the column containing the retention times. The decimal separator needs to be a point.}
}
\value{
a list of data.frames containing GC-data with aligned peaks.
}
\description{
\strong{align_peaks_fast} is a fast implementation to sort peaks strictly based on the exact retention time values across samples. See \link{align_peaks} for details on the standard approach.
}
\details{
Creates a matrix with the number of rows corresponding to the unique number of retention times across the dataset. Then, for each sample peaks are mapped to the corresponding row (=retention time) of the matrix and in parallel \code{gc_peak_list} is updated.
}
\author{
Martin Stoffel (martin.adam.stoffel@gmail.com) & Meinolf Ottensmann
 (meinolf.ottensmann@web.de)
}
\keyword{internal}
