% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemfitPD.R
\name{itemfitPD}
\alias{itemfitPD}
\title{Item fit statistics from the power-divergence family}
\usage{
itemfitPD(
  GDINA.obj,
  lambda = 2/3,
  bootstrap = FALSE,
  R = 1000,
  Stone = FALSE,
  init.parm = FALSE,
  p.adjust.method = "holm",
  person.sim = "post",
  cores = 2,
  digits = 4,
  bound = 1e-10,
  seed = 123456
)
}
\arguments{
\item{GDINA.obj}{Object containing a model fitted with the \code{GDINA::GDINA} function.}

\item{lambda}{Numeric; parameter for the power-divergence fit statistic.}

\item{bootstrap}{Logical; whether parametric bootstrap should be used.}

\item{R}{Integer; number of replicates in the bootstrap procedure if used.}

\item{Stone}{Logical; whether Stone indices should be computed (only available if \code{bootstrap = TRUE}).}

\item{init.parm}{Logical; whether the estimated item parameters are used in the estimation of the bootstrap replications.}

\item{p.adjust.method}{p-values can be adjusted for multiple comparisons at item level. This is conducted using \code{p.adjust} function in \pkg{stats},
and therefore all adjustment methods supported by \code{p.adjust} can be used, including \code{"holm"},
\code{"hochberg"}, \code{"hommel"}, \code{"bonferroni"}, \code{"BH"} and \code{"BY"}. See \code{p.adjust}
for more details. \code{"holm"} is the default.}

\item{person.sim}{Character; how to simulate attribute profiles in the bootstrap replications.}

\item{cores}{Integer; number of cores for parallelization during bootstrap.}

\item{digits}{Integer; number of decimal digits to report.}

\item{bound}{Numeric; minimum possible value for probabilities.}

\item{seed}{random seed.}
}
\value{
an object of class \code{itemfitPD} consisting of several elements including:
\describe{
\item{p}{the proportion correct statistics, adjusted and unadjusted p values for each item}
\item{r}{the transformed correlations, adjusted and unadjusted p values for each item pair}
\item{logOR}{the log odds ratios, adjusted and unadjusted p values for each item pair}
\item{maxitemfit}{the maximum proportion correct, transformed correlation, and log-odds ratio for each item with associated item-level adjusted p-values}
}
#' @importFrom foreach %dopar% foreach
}
\description{
Calculate item fit statistics from the power-divergence family
}
\examples{
\dontrun{
dat <- sim10GDINA$simdat
Q <- sim10GDINA$simQ

mod1 <- GDINA(dat = dat, Q = Q, model = "GDINA")
mod1
PDfit <- itemfitPD(mod1)
PDfit

dat <- sim21seqDINA$simdat
Q <- sim21seqDINA$simQ
sDINA <- GDINA(dat,Q,model="DINA",sequential = TRUE)
PDfit <- itemfitPD(sDINA)
PDfit
PDfit <- itemfitPD(sDINA, bootstrap = TRUE, Stone = TRUE, cores = 10)
PDfit
}
}
\references{
Najera, P., Ma, W., Sorrel, M. A. and Abad, F. J. (Under review). Assessing Item-Level Fit for the Sequential G-DINA Model.
}
\author{
Pablo Najera
  Universidad Pontificia Comillas
  \email{pnajera@comillas.edu}

Wenchao Ma
  University of Minnesota
  \email{wma@umn.edu}
}
