% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEC_features.R
\name{LRT_eigp}
\alias{LRT_eigp}
\title{Likelihood Ratio Test (LRT) for the exponent parameter in EIGP model.}
\usage{
LRT_eigp(data, theta0, theta1, eta1)
}
\arguments{
\item{data}{Observations.}

\item{theta0}{The MLE of theta when eta = 1.}

\item{theta1}{The unrestricted MLE of theta.}

\item{eta1}{The unrestricted MLE of eta.}
}
\value{
This function returns the test statistic and the p-value from the LRT test
}
\description{
This function computes the test statistic and the p-value for LRT for the exponent parameter in EIGP model.
}
\details{
LRT_eigp
}
\examples{
sample1 = eigp_sampling(200,eta = 1.1,theta = 3)
eta1 = mle_search_eigp(data = sample1)$eta
theta1 = mle_search_eigp(data = sample1)$theta
theta0 = mle_iter_eigp(data = sample1,eta = 1)
LRT_eigp(sample1,theta0,theta1,eta1)
}
