\name{getBestInit}
\alias{getBestInit}
\title{Select the Best Initialization Method for a Gaussian Mixture Model (GMM)}
\description{
Runs multiple GMM initialization strategies, computes the log-likelihood for each
initial parameter set, and selects the best initialization method based on the 
highest log-likelihood value.
}
\usage{
getBestInit(
  x, 
  k,
  init_methods = c("Random", "emEM", "emAEM",
                   "hierarchical average", "hierarchical ward",
                   "kmeans", "mclust", "cem", "sem"),
  run_number = 10,
  max_iter = 3,
  tol = 1e-6,
  burn_in = 3,verbose = FALSE
)
}
\arguments{
  \item{x}{A numeric matrix or data frame containing the data to be clustered. Each row is an observation, and each column is a feature.}

  \item{k}{The number of mixture components (clusters).}

  \item{init_methods}{
  A character vector of initialization strategies. Each method is passed to 
  \code{getInit()} to generate initial GMM parameters. The default includes:
  \itemize{
    \item \code{"Random"}
    \item \code{"emEM"}
    \item \code{"emAEM"}
    \item \code{"hierarchical average"}
    \item \code{"hierarchical ward"}
    \item \code{"kmeans"}
    \item \code{"mclust"}
    \item \code{"cem"}
    \item \code{"sem"}
  }
  }

  \item{run_number}{Number of short EM runs for EM-based initializers. Passed to \code{getInit()}.}

  \item{max_iter}{Maximum number of iterations for short EM algorithms.}

  \item{tol}{Convergence tolerance for short EM runs.}

  \item{burn_in}{Burn-in iterations for SEM-based initialization.}
  
  \item{verbose}{Logical; if TRUE, prints progress messages.}
}
\value{
A list summarizing the best initialization method and associated results:

\itemize{
  \item \code{best_method}  
    The name of the initialization method that achieved the highest log-likelihood.

  \item \code{best_result}  
    The initial parameter set (as returned by \code{getInit()}) corresponding to the best method.

  \item \code{loglik_table}  
    A data frame containing the log-likelihood achieved by each initialization method:
    \itemize{
      \item \code{method} — Method name
      \item \code{loglik} — Computed log-likelihood
    }
}
}

\seealso{
\code{\link{getInit}},  
\code{\link{runGMM}},  
\code{\link{runEM}}
}
\examples{
# Simulated data
set.seed(123)
x <- matrix(rnorm(200), ncol = 2)

# Run selection of best initialization
 result <- getBestInit(x, k = 2)

 result$best_method
 result$loglik_table
}
\keyword{initialization}
\keyword{clustering}
\keyword{GMM}
\keyword{mixture models}
