% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pTimEv.R
\name{pTimEv}
\alias{pTimEv}
\title{Model stationnary testing}
\usage{
pTimEv(
  TS,
  nVar,
  dMax,
  TSdate,
  whatTerms = NULL,
  weight = NULL,
  wlength = 1000,
  onestep = 100,
  removeExtr = 1
)
}
\arguments{
\item{TS}{The time series to be tested}

\item{nVar}{Number of variables considered in the polynomial formulation.}

\item{dMax}{Maximum degree of the polynomial formulation.}

\item{TSdate}{The time vector}

\item{whatTerms}{The terms to be considered in the analysis. Note 
that these are organised following the convention defined by
poLabs(nVar,dMax). Since only the structure is required, if
coefficients are provided, these are transformed to 1.}

\item{weight}{A vector providing the binary weighting function
of the input data series (0 or 1). By default, all the values
are set to 1.}

\item{wlength}{The window length}

\item{onestep}{Step length between two estimations}

\item{removeExtr}{Ratio of estimated values to be removed (if
chosen equal to 0.1, only 90% of the estimates of smaller
disersion will be kept)}
}
\value{
A list containing:

\code{$slidingoutGM} An n*(pMax+1) matrix presenting
the pMax estimated parameters p1(t), p2(t) etc. column by column.
The residual signal epsilon(t) is provided in the last (i.e. pMax + 1)
column. Each line correspond to one date provided in \code{$TSdate}

\code{$TSdate} A time vector relating to the estimates
presented in \code{$slidingoutGM}

\code{$W} A vector providing the output values that
can kept (=1) or must be removed (=0)

\code{$whatTerms} A vector recalling the terms
taken into account in the analysis (their order refers
to \code{poLabs(nVar,dMax)} function)

\code{$param} A vector with the parameter values
used to apply the function: nVar, dMax, wlength, onestep,
removeExtr
}
\description{
Estimate the parameters variations 
of a model of canonical form considering a sliding
window on an external dataset.
}
\examples{
#Example
data(TS)
plot(TS[,1], TS[,2], type='l')
nVar <- 3
dMax <- 2
pMax <- choose(nVar+dMax,dMax)
whatTerms <- c(1,1,0,1,1,1,1,1,1,1)
 
# apply pTimEv
statio <- pTimEv(TS[,2], nVar, dMax, TS[,1], whatTerms = whatTerms, 
                 wlength = 1000, onestep = 20, removeExtr = 0.15)
# Plot the results
dev.new()
  layout(matrix(1:12, nrow=4, ncol=3, byrow = TRUE))
  what <- which(statio$whatTerms!=0)
  for (i in what) {
      plot(statio$TSdate[statio$W==1], statio$slidingoutGM[statio$W==1,i],
           xlab='TSdate', ylab='coeff', main=poLabs(nVar,dMax)[i])
     }
  plot(statio$TSdate[statio$W==1], statio$slidingoutGM[statio$W==1,pMax+1],
       xlab='date', ylab='Epsilon', main='Resid', log = 'y')
       
}
\seealso{
\code{\link{autoGPoMoSearch}}, \code{\link{gPoMo}}, \code{\link{poLabs}}
}
\author{
Sylvain Mangiarotti
}
