% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KW.hit.express.R
\name{KW.hit.express}
\alias{KW.hit.express}
\title{Associate Lesion Groups with Gene Expression}
\usage{
KW.hit.express(alex.data, gene.annotation, min.grp.size = NULL)
}
\arguments{
\item{alex.data}{Output from the \code{\link{alex.prep.lsn.expr}} function. A list of three data frames:
\itemize{
\item \code{row.mtch}: Table of matched lesion expression entries, including gene IDs.
\item \code{alex.expr}: Gene expression matrix (rows = genes by Ensembl ID, columns = patient IDs).
\item \code{alex.lsn}: Lesion status matrix with the same dimensions/order as \code{alex.expr}.
}}

\item{gene.annotation}{Gene annotation table. Must be a \code{data.frame} with the following columns:
\code{gene} (Ensembl gene ID), \code{chrom} (chromosome), \code{loc.start} (start position), and \code{loc.end} (end position).
Can be obtained manually or via the \code{\link{get.ensembl.annotation}} function.}

\item{min.grp.size}{Minimum number of patients required in a lesion group to be included in the test. For a gene to be tested, there must be at least two groups with more than \code{min.grp.size} patients each.}
}
\value{
A data frame where each row corresponds to a gene tested. Columns include:
\item{gene}{Ensembl gene ID.}
\item{gene.name}{HGNC gene symbol.}
\item{p.KW}{Kruskal Wallis test p-value.}
\item{q.KW}{FDR-adjusted q-value for multiple testing correction.}
\item{_n.subjects}{Number of subjects in each lesion group, including "none" and "multiple".}
\item{_mean}{Mean expression per lesion group.}
\item{_median}{Median expression per lesion group.}
\item{_sd}{Standard deviation of expression per lesion group.}
}
\description{
Performs the Kruskal Wallis (KW) test to evaluate the association between lesion groups and the expression level of the corresponding gene.
}
\details{
For each row in the \code{row.mtch} table, the function performs a Kruskal Wallis test comparing expression values of the gene across lesion groups.
The lesion groups are defined in the \code{alex.lsn} matrix. Patients with multiple types of lesions in a gene are assigned the label \code{"multiple"},
and those with no lesion are labeled \code{"none"}. The expression values are obtained from the corresponding row in \code{alex.expr}.

The function tests whether expression levels significantly differ across lesion groups for the same gene.
}
\examples{
data(expr_data)
data(lesion_data)
data(hg38_gene_annotation)

# Prepare matched lesion-expression data
alex.data <- alex.prep.lsn.expr(expr_data, lesion_data,
                                hg38_gene_annotation,
                                min.expr = 1, min.pts.lsn = 5)

# Perform Kruskal Wallis test between lesion groups and expression levels:
alex.kw.results <- KW.hit.express(alex.data,
                                  hg38_gene_annotation,
                                  min.grp.size = 5)
}
\references{
Hollander, M., & Wolfe, D. A. (1973). Nonparametric Statistical Methods. New York: Wiley. pp. 115-120.

Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link{alex.prep.lsn.expr}}
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}
}
