\name{getNWCOEF}
\alias{getNWCOEF}

\title{Extract country-specific LS coefficient estimates with Newy-West robust covariance.
}

\encoding{latin1}

\description{Extract country-specific LS coefficient estimates with Newy-West robust covariance.
}

\usage{getNWCOEF(out,sheet)
}

\arguments{
  \item{out}{A list object of estimation results generated by GVARest.
}
  \item{sheet}{The number of country in out that is to be saved.
}


}


\value{
  \item{coef}{Country-specific coefficient estimates.}
}

\references{Newey WK and West KD (1994) Automatic Lag Selection in Covariance Matrix Estimation. Review of Economic Studies,61,631-653.
}

\author{Ho Tsung-wu <tsungwu@ntnu.edu.tw>, College of Management, National Taiwan Normal University.
}
\examples{
data("PriceVol")
data("tradeweight1")
data("tradeweightx")
p=2
FLag=2
lag.max=15
type="const"
ic="SC"
weight.matrix=tradeweightx
mainOUTPUT = GVARest(data=PriceVol,p,lag.max,type,ic,weight.matrix)
COEF=getNWCOEF(out=mainOUTPUT,sheet=1)
}

