% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GauPro_Gauss_LOO.R
\docType{class}
\name{GauPro_Gauss_LOO}
\alias{GauPro_Gauss_LOO}
\title{Corr Gauss GP using inherited optim}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} with methods for fitting GP model.
}
\description{
Corr Gauss GP using inherited optim

Corr Gauss GP using inherited optim
}
\examples{
n <- 12
x <- matrix(seq(0,1,length.out = n), ncol=1)
y <- sin(2*pi*x) + rnorm(n,0,1e-1)
gp <- GauPro_Gauss_LOO$new(X=x, Z=y, parallel=FALSE)
}
\section{Super classes}{
\code{\link[GauPro:GauPro_base]{GauPro::GauPro_base}} -> \code{\link[GauPro:GauPro_Gauss]{GauPro::GauPro_Gauss}} -> \code{GauPro_Gauss_LOO}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{use_LOO}}{Should the leave-one-out correction be used?}

\item{\code{tmod}}{Second GP model fit to the t-values of leave-one-out predictions}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GauPro_Gauss_LOO-update}{\code{GauPro_Gauss_LOO$update()}}
\item \href{#method-GauPro_Gauss_LOO-pred_one_matrix}{\code{GauPro_Gauss_LOO$pred_one_matrix()}}
\item \href{#method-GauPro_Gauss_LOO-print}{\code{GauPro_Gauss_LOO$print()}}
\item \href{#method-GauPro_Gauss_LOO-clone}{\code{GauPro_Gauss_LOO$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="cool1Dplot"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-cool1Dplot'><code>GauPro::GauPro_base$cool1Dplot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="deviance_searchnug"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-deviance_searchnug'><code>GauPro::GauPro_base$deviance_searchnug()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="fit"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-fit'><code>GauPro::GauPro_base$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="grad_norm"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-grad_norm'><code>GauPro::GauPro_base$grad_norm()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="initialize_GauPr"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-initialize_GauPr'><code>GauPro::GauPro_base$initialize_GauPr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="loglikelihood"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-loglikelihood'><code>GauPro::GauPro_base$loglikelihood()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="nugget_update"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-nugget_update'><code>GauPro::GauPro_base$nugget_update()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="optim"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-optim'><code>GauPro::GauPro_base$optim()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="optimRestart"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-optimRestart'><code>GauPro::GauPro_base$optimRestart()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="plot"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-plot'><code>GauPro::GauPro_base$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="plot1D"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-plot1D'><code>GauPro::GauPro_base$plot1D()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="plot2D"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-plot2D'><code>GauPro::GauPro_base$plot2D()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="pred"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-pred'><code>GauPro::GauPro_base$pred()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="pred_LOO"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-pred_LOO'><code>GauPro::GauPro_base$pred_LOO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="pred_mean"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-pred_mean'><code>GauPro::GauPro_base$pred_mean()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="pred_meanC"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-pred_meanC'><code>GauPro::GauPro_base$pred_meanC()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="pred_var"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-pred_var'><code>GauPro::GauPro_base$pred_var()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="predict"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-predict'><code>GauPro::GauPro_base$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="sample"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-sample'><code>GauPro::GauPro_base$sample()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="update_K_and_estimates"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-update_K_and_estimates'><code>GauPro::GauPro_base$update_K_and_estimates()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="update_corrparams"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-update_corrparams'><code>GauPro::GauPro_base$update_corrparams()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="update_data"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-update_data'><code>GauPro::GauPro_base$update_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_base" data-id="update_nugget"><a href='../../GauPro/html/GauPro_base.html#method-GauPro_base-update_nugget'><code>GauPro::GauPro_base$update_nugget()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="corr_func"><a href='../../GauPro/html/GauPro_Gauss.html#method-GauPro_Gauss-corr_func'><code>GauPro::GauPro_Gauss$corr_func()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="deviance"><a href='../../GauPro/html/GauPro_Gauss.html#method-GauPro_Gauss-deviance'><code>GauPro::GauPro_Gauss$deviance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="deviance_fngr"><a href='../../GauPro/html/GauPro_Gauss.html#method-GauPro_Gauss-deviance_fngr'><code>GauPro::GauPro_Gauss$deviance_fngr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="deviance_grad"><a href='../../GauPro/html/GauPro_Gauss.html#method-GauPro_Gauss-deviance_grad'><code>GauPro::GauPro_Gauss$deviance_grad()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="deviance_log"><a href='../../GauPro/html/GauPro_Gauss.html#method-GauPro_Gauss-deviance_log'><code>GauPro::GauPro_Gauss$deviance_log()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="deviance_log2"><a href='../../GauPro/html/GauPro_Gauss.html#method-GauPro_Gauss-deviance_log2'><code>GauPro::GauPro_Gauss$deviance_log2()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="deviance_log2_fngr"><a href='../../GauPro/html/GauPro_Gauss.html#method-GauPro_Gauss-deviance_log2_fngr'><code>GauPro::GauPro_Gauss$deviance_log2_fngr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="deviance_log2_grad"><a href='../../GauPro/html/GauPro_Gauss.html#method-GauPro_Gauss-deviance_log2_grad'><code>GauPro::GauPro_Gauss$deviance_log2_grad()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="deviance_log_grad"><a href='../../GauPro/html/GauPro_Gauss.html#method-GauPro_Gauss-deviance_log_grad'><code>GauPro::GauPro_Gauss$deviance_log_grad()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="deviance_theta"><a href='../../GauPro/html/GauPro_Gauss.html#method-GauPro_Gauss-deviance_theta'><code>GauPro::GauPro_Gauss$deviance_theta()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="deviance_theta_log"><a href='../../GauPro/html/GauPro_Gauss.html#method-GauPro_Gauss-deviance_theta_log'><code>GauPro::GauPro_Gauss$deviance_theta_log()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="get_optim_functions"><a href='../../GauPro/html/GauPro_Gauss.html#method-GauPro_Gauss-get_optim_functions'><code>GauPro::GauPro_Gauss$get_optim_functions()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="grad"><a href='../../GauPro/html/GauPro_Gauss.html#method-GauPro_Gauss-grad'><code>GauPro::GauPro_Gauss$grad()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="grad_dist"><a href='../../GauPro/html/GauPro_Gauss.html#method-GauPro_Gauss-grad_dist'><code>GauPro::GauPro_Gauss$grad_dist()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="hessian"><a href='../../GauPro/html/GauPro_Gauss.html#method-GauPro_Gauss-hessian'><code>GauPro::GauPro_Gauss$hessian()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="initialize"><a href='../../GauPro/html/GauPro_Gauss.html#method-GauPro_Gauss-initialize'><code>GauPro::GauPro_Gauss$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="param_optim_jitter"><a href='../../GauPro/html/GauPro_Gauss.html#method-GauPro_Gauss-param_optim_jitter'><code>GauPro::GauPro_Gauss$param_optim_jitter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="param_optim_lower"><a href='../../GauPro/html/GauPro_Gauss.html#method-GauPro_Gauss-param_optim_lower'><code>GauPro::GauPro_Gauss$param_optim_lower()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="param_optim_start"><a href='../../GauPro/html/GauPro_Gauss.html#method-GauPro_Gauss-param_optim_start'><code>GauPro::GauPro_Gauss$param_optim_start()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="param_optim_start0"><a href='../../GauPro/html/GauPro_Gauss.html#method-GauPro_Gauss-param_optim_start0'><code>GauPro::GauPro_Gauss$param_optim_start0()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="param_optim_upper"><a href='../../GauPro/html/GauPro_Gauss.html#method-GauPro_Gauss-param_optim_upper'><code>GauPro::GauPro_Gauss$param_optim_upper()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="update_params"><a href='../../GauPro/html/GauPro_Gauss.html#method-GauPro_Gauss-update_params'><code>GauPro::GauPro_Gauss$update_params()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss_LOO-update"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss_LOO-update}{}}}
\subsection{Method \code{update()}}{
Update the model, can be data and parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss_LOO$update(
  Xnew = NULL,
  Znew = NULL,
  Xall = NULL,
  Zall = NULL,
  restarts = 5,
  param_update = self$param.est,
  nug.update = self$nug.est,
  no_update = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Xnew}}{New X matrix}

\item{\code{Znew}}{New Z values}

\item{\code{Xall}}{Matrix with all X values}

\item{\code{Zall}}{All Z values}

\item{\code{restarts}}{Number of optimization restarts}

\item{\code{param_update}}{Should the parameters be updated?}

\item{\code{nug.update}}{Should the nugget be updated?}

\item{\code{no_update}}{Should none of the parameters/nugget be updated?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss_LOO-pred_one_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss_LOO-pred_one_matrix}{}}}
\subsection{Method \code{pred_one_matrix()}}{
Predict mean and se for given matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss_LOO$pred_one_matrix(XX, se.fit = F, covmat = F)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{XX}}{Points to predict at}

\item{\code{se.fit}}{Should the se be returned?}

\item{\code{covmat}}{Should the covariance matrix be returned?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss_LOO-print"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss_LOO-print}{}}}
\subsection{Method \code{print()}}{
Print this object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss_LOO$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_Gauss_LOO-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_Gauss_LOO-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss_LOO$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
