% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimQuantilesWBM.R
\name{SimQuantilesWBM}
\alias{SimQuantilesWBM}
\title{Function to estimate quantiles for weigthed Brownian Motion functional}
\usage{
SimQuantilesWBM(
  n,
  d,
  gamma,
  B = 50000,
  alpha = c(0.9, 0.95, 0.975, 0.99),
  n_cores = 2
)
}
\arguments{
\item{n}{number of points}

\item{d}{dimension of Brownian motion}

\item{gamma}{parameter between 0 and 0.5 (not included)}

\item{B}{number of bootstrap samples (default 50000)}

\item{alpha}{vector of probabilities (default is (.90,.95,.975,.99))}

\item{n_cores}{number of cores for parallel computing (default is 2)}
}
\value{
\item{qs}{Simulated quantiles of weighted BM}
}
\description{
Function to calculate the critical value for the Euclidean norm of  d-dimensional  BM divided by t^gamma
}
