% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PEE_MultiTaxa.R
\name{PEE_MultiTaxa}
\alias{PEE_MultiTaxa}
\title{Function to compile the PBDB_PEE_SingleTaxon output for a list of taxa}
\usage{
PEE_MultiTaxa(GeoRare_Multi)
}
\arguments{
\item{GeoRare_Multi}{- The list of geographic range measures calculated from the GeoRarefaction_MultiTaxa function}
}
\value{
Returns a vector list of six geographic range measures matrix with percent error of estimates [1] for each value
}
\description{
Function to compile the PBDB_PEE_SingleTaxon output for a list of taxa
}
\examples{
\dontrun{
data(BivalvePBDB)
BivalveMatrix<-CoordList_PBDB(BivalvePBDB)
BivalveGeo<-GeoRarefaction_MultiTaxa(nLocCut=20,OccMatrix=BivalveMatrix,TaxaStart=3,replacePts=TRUE)
PEE_MultiTaxa(BivalveGeo)
}
}
\references{
[1] Russell, M.P. & D.R. Lindberg. 1988. Real and Random Patterns Associated with Molluscan Spatial and Temporal Distributions. Paleobiology 14:322-330.
}
\seealso{
See the velociraptr package for details of the downloadPBDB() function
}
