% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandHorseShoe.R
\name{RandHorseShoe}
\alias{RandHorseShoe}
\title{Function to randomly generate points within a horseshoe-shape}
\usage{
RandHorseShoe(center = c(0, 0), npts = 100, HorseShoeShape, HRatio = 1.5,
  RadRatio = 0.5)
}
\arguments{
\item{center}{- Arrary containint the coordinates of the center of circular portion of the horseshoe in decimal degrees}

\item{npts}{- Integer value indicating the number of points to generate within the horseshoe shape}

\item{HorseShoeShape}{- Object containing the outline of a horseshoe shape, output from PtsAlgHorseShoe function}

\item{HRatio}{- The ratio of the lower rectangle portions of the horseshoe to the outer radius of the circular portion of the horseshoe}

\item{RadRatio}{- The ration of the of the outer to inner radius of the circular part of the horseshoe shape}
}
\value{
Returns a 2-dimensional array of decimal degree coordinates within the horseshoe shape and the total area of the shape
}
\description{
Function to randomly generate points within a horseshoe-shape
}
\note{
HRatio Currently defaults to 3/2 per the PtsAlgHorseShoe() function
RadRatio currently defaults to 1/2 per the PtsAlgHorseShoe() function
Center currently defaults to c(0,0) as this is always the center of the PtsAlgHorseShoe() function currently
Function currently does not take acount of the decreasing surface area moving toward the poles so points closer to the poles will be overrepresented relative to the actual surface area they represent
}
\examples{
HorseShoeTest<-PtsAlgHorseShoe(z=2000,spacing=1,endAngles=c(-90,90))
RandHorseShoe(center=c(0,0),npts=100,HorseShoeShape=HorseShoeTest)
}
