% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reversePCA.R
\name{reversePCA}
\alias{reversePCA}
\title{'Reverse' PCA}
\usage{
reversePCA(Scores, Eigenvectors, Mean)
}
\arguments{
\item{Scores}{matrix n x s of n observation for s scores. Can be a
single column (for instance, if one is interested in PC1 only)}

\item{Eigenvectors}{matrix p x s of eigenvectors (as column
eigenvectors); notice that s (number of column eigenvectors) must
be the same as the number of columns of PC scores in Scores}

\item{Mean}{vector of length p with the multivariate mean computed
on the original dataset (the dataset on which the PCA was carried
out)}
}
\value{
The function outputs a matrix n x p of the scores 'back-transformed'
into the original variables
}
\description{
Obtain data in the original variables starting from PCA scores
}
\details{
Given a set of PCA scores, a set of eigenvectors and the mean of
the data on which the PCA was originally computed, this function
returns a set of observations in the original data space.
This simple function can have many applications (not only in
morphometrics) such as
 \itemize{
  \item Producing predicted shapes for extreme, unobserved, values
  of PC scores (e.g., the shape, or other set of variables,
  corresponding to 3 times the most extreme positive PC1 score), or
  their combinations (e.g., a value of 0.4 on PC1 and 0.3 on PC2)
  \item Interpret results of analyses carried out on PC scores by
  converting these back to shapes
}
}
\examples{

library(MASS)
set.seed(123)
A=mvrnorm(10,mu=rep(1,2),Sigma=diag(2))
# Create a small dataset of 10 observations and 2 variables

Mean=colMeans(A)
PCA=prcomp(A)
# Compute mean and perform PCA

B=reversePCA(Scores=PCA$x, Eigenvectors=PCA$rotation, Mean=Mean)
# 'Revert' the PCA (in this case using all scores and all axes
# to get the same results as the starting data)

round(A,10)==round(B,10)
# Check that all the results are the same
# (rounding to the 10th decimal because of numerical precision)


}
