% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssa.otl.R
\name{ssa.otl}
\alias{ssa.otl}
\title{Optimized tau-leap method (OTL)}
\usage{
ssa.otl(epsilon = 0.03, nc = 10, hor = NA_real_, dtf = 10, nd = 100)
}
\arguments{
\item{epsilon}{error control parameter.}

\item{nc}{number of critical reactions threshold parameter.}

\item{hor}{Highest order reaction vector. There must be one entry per species in \code{x}.
Must be one of \code{1}: first-order, \code{2}: second-order or \code{22}: homo-dimer.
If \code{hor} is \code{NA}, defaults are all second-order.}

\item{dtf}{Direct method threshold factor for temporarily suspending the
\code{OTL} method.}

\item{nd}{number of Direct method steps to perform during an \code{OTL}
suspension.}
}
\description{
Optimized tau-leap method implementation of the \acronym{SSA} as described
by Cao et al. (2006). Should be passed as \code{method} argument for \code{ssa()}.
}
\note{
Third order-reactions (\eqn{S_1+S_2+S_3 \rightarrow \ldots}{S_1 + S_2
+ S_3 ---> ...}) are not supported currently since they are approximations
to sets of coupled first- and second-order reactions). See Cao et al. (2006)
for more details.
}
\examples{
ssa.otl(
  hor = 1,
  nc = 10,
  epsilon = .03,
  dtf = 10,
  nd = 100
)
}
\references{
Cao et al. (2006)
}
\seealso{
\link{GillespieSSA-package}, \code{\link[=ssa]{ssa()}}
}
\keyword{datagen}
\keyword{misc}
\keyword{ts}
