% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxGrobs_align.R
\name{align}
\alias{align}
\alias{alignVertical}
\alias{alignHorizontal}
\title{Align boxes}
\usage{
alignVertical(
  reference,
  ...,
  .position = c("center", "top", "bottom"),
  .subelement = NULL
)

alignHorizontal(
  reference,
  ...,
  .position = c("center", "left", "right"),
  .sub_position = c("none", "left", "right"),
  .subelement = NULL
)
}
\arguments{
\item{reference}{A \code{\link{boxGrob}}/\code{\link{boxPropGrob}}/\code{\link{coords}} object or a \code{\link[grid:unit]{unit}} or a
numerical value that can be converted into a \code{\link[grid:unit]{unit}} of \code{npc} type.}

\item{...}{A set of boxes.}

\item{.position}{How to align the boxes, differs slightly for vertical and horizontal alignment
see the accepted arguments}

\item{.subelement}{If a \code{list} of boxes is provided, this parameter can be used
to target a specific element (by name or index) for the alignment operation.
The function will then return the original list with the targeted element
replaced by its aligned version.}

\item{.sub_position}{When the box is a \code{\link{boxPropGrob}} it not only has the general \code{.positions} but
also \code{left} and \code{right} which can be viewed as separate boxes that have simply been merged.}
}
\value{
\code{list} with the boxes that are to be aligned
}
\description{
Aligns a set of \code{\link{boxGrob}}/\code{\link{boxPropGrob}} according to the first positional argument.
}
\examples{
library(grid)
grid.newpage()

# Create a reference box
box <- boxGrob("A cool reference box",
  x = .5, y = .8,
  box_gp = gpar(fill = "#ADB5C7")
)

# Create a group of boxes to align
boxes <- list(
  another_box = boxGrob("A horizontal box", x = .1, y = .5),
  yet_another_box = boxGrob("Another horizontal box", x = .8, y = .3)
)

# Align the group and then individual boxes within that group
aligned_boxes <- boxes |>
  alignHorizontal(reference = box, .position = "right") |>
  alignVertical(reference = .5, .position = "center")

# Print the reference and the aligned boxes
box
aligned_boxes
}
\seealso{
Other flowchart components: 
\code{\link{boxGrob}()},
\code{\link{boxPropGrob}()},
\code{\link{boxShapes}},
\code{\link{connectGrob}()},
\code{\link{coords}()},
\code{\link{distance}()},
\code{\link{moveBox}()},
\code{\link{spread}}
}
\concept{flowchart components}
