% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxGrobs_labelConnector.R
\name{labelConnector}
\alias{labelConnector}
\title{Label connector grobs}
\usage{
labelConnector(
  con,
  labels,
  x_offset = unit(0, "mm"),
  y_offset = unit(0, "mm"),
  gp = gpar(cex = 0.9),
  bg_gp = gpar(fill = "white", col = NA),
  pad = unit(2, "mm")
)
}
\arguments{
\item{con}{A list of connector grobs produced by `connectGrob()` (typically
a `connect_boxes_list`).}

\item{labels}{A character vector of labels (recycled if necessary).}

\item{x_offset, y_offset}{`grid::unit` offsets added to the label position.}

\item{gp}{A `grid::gpar` object controlling text appearance.}

\item{bg_gp}{A `grid::gpar` object controlling label background appearance.}

\item{pad}{A `grid::unit` padding to add around text inside the background box.}
}
\value{
A `Gmisc_connector_label` S3 object (invisible). Use `print()` to draw the labels.
}
\description{
Place text labels at the midpoint of connector grobs returned by
`connectGrob()` (useful for multi-target connectors where `label=` isn't
available). By default the function draws the labels; set `draw = FALSE` to
only return the `textGrob` objects for programmatic use.
}
\examples{
# Attach labels to a previously-created connector and draw them
a <- boxDiamondGrob("D")
b <- boxEllipseGrob("L")
c <- boxServerGrob("S")
boxes <- list(decision = a, outcomes = list(b, c)) |>
    spreadHorizontal(
        .from = grid::unit(.1, "npc"),
        .to = grid::unit(.9, "npc"),
        .subelement = "outcomes"
    ) |>
    spreadVertical()

connectGrob(boxes$decision, boxes$outcomes, type = "N") |>
    labelConnector(c("Local", "Server"))
}
