% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_model_residual_plots.R
\name{growth_model_residual_plots}
\alias{growth_model_residual_plots}
\title{Create residual diagnostic plots for growth model}
\usage{
growth_model_residual_plots(
  growth_model_summary_list,
  residual_type = "cluster",
  weighted = TRUE
)
}
\arguments{
\item{growth_model_summary_list}{A list object created by the
\code{\link{growth_curve_model_fit}} function.}

\item{residual_type}{A character string specifying the type of residuals
to be displayed in the plot. Options include "population" for the
fixed-effects residuals for mixed-effects and least-squares models and
"cluster" for fixed and random-effects residuals for mixed-effects
regression models. Defaults to "cluster".}

\item{weighted}{A logical value, when TRUE displays weighted residuals for
mixed-effects models or standardized residuals for least-squares models,
when FALSE displays the raw residuals for mixed-effects and least-squares
models. Defaults to "TRUE".}
}
\value{
Returns a patchwork collage of ggplot2 model diagnostic plots with
the following plots displayed:
\itemize{
\item Residual vs Fitted Values - a model diagnostic plot for assessing
the distribution of the residuals vs the model fitted values,
useful in detecting improper function specification, homogeneity of
variance, and outlier detection.
\item Q-Q Plot - a model diagnostic plot (quantile-quantile) plot for
comparing the residuals vs their theoretical quantiles,
useful in assessing normality assumptions and outlier detection.
\item Residual Density Plot - a model diagnostic showing the distribution
of the residuals (histogram) with a normal distribution curve
overlaid based on the residuals mean and standard deviation, useful in
assessing normality assumptions and skewness.
\item Residual Summary Statistics - a list of descriptive statistics of
the the residuals including: mean, median, minimum, maximum,
skewness, and kurtosis.
}
}
\description{
This function provides a wrapper to ggplot2 for generating residual
diagnostic plots and summary statistics for a growth model summary list
object produced by \code{\link{growth_curve_model_fit}}.
}
\examples{
\donttest{
# Load example data (exponential data)
data(exp_mixed_data)
# Fit an mixed-effects growth model to the data and produce summary list
exp_mixed_model_summary <- growth_curve_model_fit(
data_frame = exp_mixed_data,
function_type = "exponential",
verbose = FALSE)
# Check residuals and model assumptions
residual_diag_plot <- growth_model_residual_plots(
  growth_model_summary_list = exp_mixed_model_summary)
print(residual_diag_plot)
}
}
\seealso{
\code{\link{growth_curve_model_fit}}
}
